/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.common.util;

import com.ibm.hsc.common.exceptions.PIHscClientException;
import com.ibm.hsc.common.util.PIHscUtil;
import com.ibm.hsc.common.util.Trace;
import com.ibm.hwmca.base.custinfo.CustomerInfoData;
import java.io.UnsupportedEncodingException;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.util.Vector;
import org.snia.wbem.cim.CIMClass;
import org.snia.wbem.cim.CIMException;
import org.snia.wbem.cim.CIMInstance;
import org.snia.wbem.cim.CIMObjectPath;
import org.snia.wbem.cim.CIMProperty;
import org.snia.wbem.cim.CIMValue;
import org.snia.wbem.cim.UnsignedInt8;
import org.snia.wbem.client.CIMClient;

public class ContactInfo {
    public static final String ORGANIZATION_NAME = "O";
    public static final String CONTACT_NAME = "CN";
    public static final String PRIMARY_TELEPHONE_NUMBER = "PP";
    public static final String ALTERNATE_TELEPHONE_NUMBER = "AP";
    public static final String PRIMARY_FAX_NUMBER = "PF";
    public static final String ALTERNATE_FAX_NUMBER = "AF";
    public static final String STREET_ADDRESS = "AD";
    public static final String CITY = "L";
    public static final String STATE = "ST";
    public static final String REGION = "C";
    public static final String POSTAL_CODE = "PC";
    private static final int ORGANIZATION_NAME_VALUE_MIN = 25;
    private static final int CONTACT_NAME_VALUE_MIN = 25;
    private static final int PRIMARY_TELEPHONE_NUMBER_VALUE_MIN = 20;
    private static final int ALTERNATE_TELEPHONE_NUMBER_VALUE_MIN = 0;
    private static final int PRIMARY_FAX_NUMBER_VALUE_MIN = 0;
    private static final int ALTERNATE_FAX_NUMBER_VALUE_MIN = 0;
    private static final int STREET_ADDRESS_VALUE_MIN = 65;
    private static final int CITY_VALUE_MIN = 35;
    private static final int STATE_VALUE_MIN = 3;
    private static final int REGION_VALUE_MIN = 2;
    private static final int POSTAL_CODE_VALUE_MIN = 12;
    private static final int BYTES_FOR_EQUAL_SIGN_AND_SEMICOLON = 2;
    private static final int MAX_BYTE_SIZE = 702;
    private static final String TRACE_MASKD = "JUTLCTID";
    private static final String TRACE_MASKF = "JUTLCTIF";
    private static final String TRACE_MASKT = "JUTLCTIT";
    private String orgName = null;
    private String contactName = null;
    private String primaryPhone = null;
    private String alternatePhone = null;
    private String primaryFax = null;
    private String alternateFax = null;
    private String streetAddress = null;
    private String locality = null;
    private String stateCode = null;
    private String countryCode = null;
    private String postalCode = null;
    static /* synthetic */ Class class$com$ibm$hsc$common$util$ContactInfo;

    private ContactInfo(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, String string11) {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "->ContactInfo( " + string + "," + string2 + "," + string3 + "," + string4 + "," + string5 + "," + string6 + "," + string7 + "," + string8 + "," + string9 + "," + string10 + "," + string11 + ")");
        }
        this.orgName = string;
        this.contactName = string2;
        this.primaryPhone = string3;
        this.alternatePhone = string4;
        this.primaryFax = string5;
        this.alternateFax = string6;
        this.streetAddress = string7;
        this.locality = string8;
        this.stateCode = string9;
        this.countryCode = string10;
        this.postalCode = string11;
    }

    public ContactInfo(CustomerInfoData customerInfoData) {
        String string = null;
        String string2 = null;
        int n = 0;
        int n2 = 0;
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "->ContactInfo( " + customerInfoData + ")");
        }
        if (customerInfoData != null) {
            this.orgName = customerInfoData.getAdminCompany();
            this.contactName = customerInfoData.getAdminName();
            this.primaryPhone = customerInfoData.getAdminPhone();
            this.alternatePhone = customerInfoData.getAdminAltPhone();
            this.primaryFax = customerInfoData.getAdminFax();
            this.alternateFax = customerInfoData.getAdminAltFax();
            string = customerInfoData.getAdminStreetAddr();
            if (string != null) {
                n = string.length();
            }
            if ((string2 = customerInfoData.getAdminStreetAddr2()) != null) {
                n2 = string2.length();
            }
            this.streetAddress = string != null && n > 0 ? (string2 != null && n2 > 0 ? string + "\n" + string2 : string) : (string2 != null && n2 > 0 ? string2 : "");
            this.locality = customerInfoData.getAdminCity();
            this.stateCode = customerInfoData.getAdminSubdivisionCode();
            this.countryCode = customerInfoData.getAdminCountryCode();
            this.postalCode = customerInfoData.getAdminPostalCode();
        }
    }

    public static void main(String[] stringArray) {
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        String string8 = null;
        String string9 = null;
        String string10 = null;
        String string11 = null;
        String string12 = null;
        if (stringArray.length <= 1) {
            System.out.println("Usage java " + (class$com$ibm$hsc$common$util$ContactInfo == null ? (class$com$ibm$hsc$common$util$ContactInfo = ContactInfo.class$("com.ibm.hsc.common.util.ContactInfo")) : class$com$ibm$hsc$common$util$ContactInfo).getName() + " cECMTMS " + "[" + ORGANIZATION_NAME + "=orgName] " + "[" + CONTACT_NAME + "=contactName] " + "[" + PRIMARY_TELEPHONE_NUMBER + "=primaryPhone] " + "[" + ALTERNATE_TELEPHONE_NUMBER + "=alternatePhone] " + "[" + PRIMARY_FAX_NUMBER + "=primaryFax] " + "[" + ALTERNATE_FAX_NUMBER + "=alternateFax] " + "[" + STREET_ADDRESS + "=streetAddress] " + "[" + CITY + "=city] " + "[" + STATE + "=stateCode] " + "[" + REGION + "=countryCode] " + "[" + POSTAL_CODE + "=postalCode]");
            System.exit(-1);
        }
        try {
            for (int i = 1; i < stringArray.length; ++i) {
                string12 = ContactInfo.getValue(stringArray[i], ORGANIZATION_NAME);
                if (string12 != null) {
                    string = string12;
                }
                if ((string12 = ContactInfo.getValue(stringArray[i], CONTACT_NAME)) != null) {
                    string2 = string12;
                }
                if ((string12 = ContactInfo.getValue(stringArray[i], PRIMARY_TELEPHONE_NUMBER)) != null) {
                    string3 = string12;
                }
                if ((string12 = ContactInfo.getValue(stringArray[i], ALTERNATE_TELEPHONE_NUMBER)) != null) {
                    string4 = string12;
                }
                if ((string12 = ContactInfo.getValue(stringArray[i], PRIMARY_FAX_NUMBER)) != null) {
                    string5 = string12;
                }
                if ((string12 = ContactInfo.getValue(stringArray[i], ALTERNATE_FAX_NUMBER)) != null) {
                    string6 = string12;
                }
                if ((string12 = ContactInfo.getValue(stringArray[i], STREET_ADDRESS)) != null) {
                    string7 = string12;
                }
                if ((string12 = ContactInfo.getValue(stringArray[i], CITY)) != null) {
                    string8 = string12;
                }
                if ((string12 = ContactInfo.getValue(stringArray[i], STATE)) != null) {
                    string9 = string12;
                }
                if ((string12 = ContactInfo.getValue(stringArray[i], REGION)) != null) {
                    string10 = string12;
                }
                if ((string12 = ContactInfo.getValue(stringArray[i], POSTAL_CODE)) == null) continue;
                string11 = string12;
            }
            System.out.println("HSC Information before set is " + ContactInfo.getHSCInfo(stringArray[0]));
            new ContactInfo(string, string2, string3, string4, string5, string6, string7, string8, string9, string10, string11).setHSCInfo(stringArray[0]);
            System.out.println("HSC Information after set is " + ContactInfo.getHSCInfo(stringArray[0]));
            System.out.println("HSC Information before delete is " + ContactInfo.getHSCInfo(stringArray[0]));
            new ContactInfo(string, string2, string3, string4, string5, string6, string7, string8, string9, string10, string11).deleteHSCInfo(stringArray[0]);
            System.out.println("HSC Information after delete is " + ContactInfo.getHSCInfo(stringArray[0]));
        }
        catch (Throwable throwable) {
            System.out.println("Throwable caught in main() : " + throwable);
            throwable.printStackTrace();
        }
    }

    public void setHSCInfo(String string) throws CIMException, UnknownHostException {
        this.changeHSCInfo(string, false);
    }

    public void deleteHSCInfo(String string) throws CIMException, UnknownHostException {
        this.changeHSCInfo(string, true);
    }

    private void changeHSCInfo(String string, boolean bl) throws CIMException, UnknownHostException {
        CIMClient cIMClient = null;
        Object var4_4 = null;
        Object var5_5 = null;
        int n = 0;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        String string8 = null;
        String string9 = null;
        String string10 = null;
        String string11 = null;
        String string12 = null;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "->changeHscInfo( " + string + ", " + bl + ")");
        }
        if ((cIMClient = PIHscUtil.openCIMClient("127.0.0.1")) != null) {
            if (3 <= Trace.LEVEL) {
                Trace.trace(TRACE_MASKD, "got CIM client");
            }
            if (bl) {
                ContactInfo.delete(cIMClient, string, ORGANIZATION_NAME);
                ContactInfo.delete(cIMClient, string, CONTACT_NAME);
                ContactInfo.delete(cIMClient, string, PRIMARY_TELEPHONE_NUMBER);
                ContactInfo.delete(cIMClient, string, ALTERNATE_TELEPHONE_NUMBER);
                ContactInfo.delete(cIMClient, string, PRIMARY_FAX_NUMBER);
                ContactInfo.delete(cIMClient, string, ALTERNATE_FAX_NUMBER);
                ContactInfo.delete(cIMClient, string, STREET_ADDRESS);
                ContactInfo.delete(cIMClient, string, CITY);
                ContactInfo.delete(cIMClient, string, STATE);
                ContactInfo.delete(cIMClient, string, REGION);
                ContactInfo.delete(cIMClient, string, POSTAL_CODE);
            } else {
                n = 0;
                string12 = ContactInfo.encodeValue(this.postalCode);
                n += ContactInfo.calcLength(POSTAL_CODE, string12);
                string11 = ContactInfo.encodeValue(this.countryCode);
                n += ContactInfo.calcLength(REGION, string11);
                string10 = ContactInfo.encodeValue(this.stateCode);
                n += ContactInfo.calcLength(STATE, string10);
                string4 = ContactInfo.encodeValue(this.primaryPhone);
                n += ContactInfo.calcLength(PRIMARY_TELEPHONE_NUMBER, string4);
                if (3 <= Trace.LEVEL) {
                    Trace.trace(TRACE_MASKD, "Total length of contact information fields that are not truncated is " + n);
                }
                string9 = ContactInfo.encodeValue(this.locality, 35);
                n2 = ContactInfo.calcLength(CITY, string9);
                string8 = ContactInfo.encodeValue(this.streetAddress, 65);
                n3 = ContactInfo.calcLength(STREET_ADDRESS, string8);
                string3 = ContactInfo.encodeValue(this.contactName, 25);
                n4 = ContactInfo.calcLength(CONTACT_NAME, string3);
                string2 = ContactInfo.encodeValue(this.orgName, 25);
                n5 = ContactInfo.calcLength(ORGANIZATION_NAME, string2);
                n += n2 + n3 + n4 + n5;
                if (3 <= Trace.LEVEL) {
                    Trace.trace(TRACE_MASKD, "Total length of minimal contact information fields is " + n);
                }
                string9 = ContactInfo.asMuchAsFits(n -= n2, CITY, this.locality);
                n += ContactInfo.calcLength(CITY, string9);
                string8 = ContactInfo.asMuchAsFits(n -= n3, STREET_ADDRESS, this.streetAddress);
                n += ContactInfo.calcLength(STREET_ADDRESS, string8);
                string3 = ContactInfo.asMuchAsFits(n -= n4, CONTACT_NAME, this.contactName);
                string5 = ContactInfo.asMuchAsFits(n += ContactInfo.calcLength(CONTACT_NAME, string3), ALTERNATE_TELEPHONE_NUMBER, this.alternatePhone);
                n += ContactInfo.calcLength(ALTERNATE_TELEPHONE_NUMBER, string5);
                string2 = ContactInfo.asMuchAsFits(n -= n5, ORGANIZATION_NAME, this.orgName);
                string6 = ContactInfo.asMuchAsFits(n += ContactInfo.calcLength(ORGANIZATION_NAME, string2), PRIMARY_FAX_NUMBER, this.primaryFax);
                string7 = ContactInfo.asMuchAsFits(n += ContactInfo.calcLength(PRIMARY_FAX_NUMBER, string6), ALTERNATE_FAX_NUMBER, this.alternateFax);
                n += ContactInfo.calcLength(ALTERNATE_FAX_NUMBER, string7);
                if (3 <= Trace.LEVEL) {
                    StringBuffer stringBuffer = new StringBuffer();
                    if (string2 != null && string2.length() > 0) {
                        stringBuffer.append("O=" + string2 + ";");
                    }
                    if (string3 != null && string3.length() > 0) {
                        stringBuffer.append("CN=" + string3 + ";");
                    }
                    if (string4 != null && string4.length() > 0) {
                        stringBuffer.append("PP=" + string4 + ";");
                    }
                    if (string5 != null && string5.length() > 0) {
                        stringBuffer.append("AP=" + string5 + ";");
                    }
                    if (string6 != null && string6.length() > 0) {
                        stringBuffer.append("PF=" + string6 + ";");
                    }
                    if (string7 != null && string7.length() > 0) {
                        stringBuffer.append("AF=" + string7 + ";");
                    }
                    if (string8 != null && string8.length() > 0) {
                        stringBuffer.append("AD=" + string8 + ";");
                    }
                    if (string9 != null && string9.length() > 0) {
                        stringBuffer.append("L=" + string9 + ";");
                    }
                    if (string10 != null && string10.length() > 0) {
                        stringBuffer.append("ST=" + string10 + ";");
                    }
                    if (string11 != null && string11.length() > 0) {
                        stringBuffer.append("C=" + string11 + ";");
                    }
                    if (string12 != null && string12.length() > 0) {
                        stringBuffer.append("PC=" + string12 + ";");
                    }
                    if (stringBuffer.length() > 0) {
                        Trace.trace(TRACE_MASKD, "Setting contact information of length " + n + " and the following content:");
                        Trace.trace(TRACE_MASKD, stringBuffer.toString());
                    }
                }
                ContactInfo.setOrDelete(cIMClient, string, ORGANIZATION_NAME, string2);
                ContactInfo.setOrDelete(cIMClient, string, CONTACT_NAME, string3);
                ContactInfo.setOrDelete(cIMClient, string, PRIMARY_TELEPHONE_NUMBER, string4);
                ContactInfo.setOrDelete(cIMClient, string, ALTERNATE_TELEPHONE_NUMBER, string5);
                ContactInfo.setOrDelete(cIMClient, string, PRIMARY_FAX_NUMBER, string6);
                ContactInfo.setOrDelete(cIMClient, string, ALTERNATE_FAX_NUMBER, string7);
                ContactInfo.setOrDelete(cIMClient, string, STREET_ADDRESS, string8);
                ContactInfo.setOrDelete(cIMClient, string, CITY, string9);
                ContactInfo.setOrDelete(cIMClient, string, STATE, string10);
                ContactInfo.setOrDelete(cIMClient, string, REGION, string11);
                ContactInfo.setOrDelete(cIMClient, string, POSTAL_CODE, string12);
            }
        } else {
            throw new CIMException("CIMClient is null.");
        }
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<-changeHscInfo(...)");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getHSCInfo(String string) throws CIMException, PIHscClientException {
        String string2 = null;
        String string3 = null;
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "->getHscInfo( " + string + ")");
        }
        string2 = "127.0.0.1";
        CIMObjectPath cIMObjectPath = null;
        Object var4_4 = null;
        Vector vector = null;
        Vector vector2 = null;
        CIMValue cIMValue = null;
        boolean bl = false;
        boolean bl2 = false;
        Object var10_10 = null;
        short s = 0;
        Vector vector3 = null;
        Vector vector4 = null;
        UnsignedInt8 unsignedInt8 = null;
        String string4 = null;
        cIMObjectPath = new CIMObjectPath("IBMHSC_ComputerSystem", "root/ibmhscS1_0");
        if (cIMObjectPath == null) throw new CIMException("CIMObjectPath is null.");
        cIMObjectPath.addKey("CreationClassName", new CIMValue((Object)"IBMHSC_ComputerSystem"));
        cIMObjectPath.addKey("Name", new CIMValue((Object)string));
        s = 0;
        vector = new Vector();
        vector2 = new Vector();
        cIMValue = PIHscUtil.invokeCIMMethod(string2, cIMObjectPath, "GetPHYPHmcInfo", vector, vector2);
        if (cIMValue == null) throw new CIMException("return value is null.");
        vector3 = (Vector)((CIMProperty)vector2.elementAt(0)).getValue().getValue();
        vector4 = (Vector)((CIMProperty)vector2.elementAt(1)).getValue().getValue();
        if (vector3 != null && vector3.size() > 0) {
            for (int i = 0; i < vector3.size(); ++i) {
                unsignedInt8 = (UnsignedInt8)vector3.get(i);
                string4 = (String)vector4.get(i);
                if (unsignedInt8 == null || unsignedInt8.shortValue() != s) continue;
                string3 = string4;
                break;
            }
        }
        if (1 > Trace.LEVEL) return string3;
        Trace.trace(TRACE_MASKT, "<-getHscInfo(...) returning " + string3);
        return string3;
    }

    private static void setOrDelete(CIMClient cIMClient, String string, String string2, String string3) throws CIMException {
        if (string3 != null && string3.length() > 0) {
            ContactInfo.set(cIMClient, string, string2, string3);
        } else {
            ContactInfo.delete(cIMClient, string, string2);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void set(CIMClient cIMClient, String string, String string2, String string3) throws CIMException {
        CIMClass cIMClass = null;
        CIMInstance cIMInstance = null;
        CIMObjectPath cIMObjectPath = null;
        boolean bl = false;
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "->set(" + cIMClient + ", " + string + ", " + string2 + ", " + string3 + ")");
        }
        if (string2 != null) {
            cIMObjectPath = new CIMObjectPath("IBMHSC_HscInfo");
            if (cIMObjectPath == null) throw new CIMException("CIMObjectPath is null.");
            if (3 <= Trace.LEVEL) {
                Trace.trace(TRACE_MASKD, "got CIM object path");
            }
            cIMObjectPath.addKey("ComputerSystemCreationClassName", new CIMValue((Object)"IBMHSC_ComputerSystem"));
            cIMObjectPath.addKey("ComputerSystemName", new CIMValue((Object)string));
            cIMObjectPath.addKey("DataTag", new CIMValue((Object)string2));
            try {
                cIMClient.setProperty(cIMObjectPath, "Data", new CIMValue((Object)string3));
            }
            catch (CIMException cIMException) {
                bl = true;
            }
            catch (NullPointerException nullPointerException) {
                bl = true;
            }
            if (bl) {
                cIMClass = cIMClient.getClass(cIMObjectPath, false);
                if (cIMClass == null) throw new CIMException("CIMClass is null.");
                cIMInstance = cIMClass.newInstance();
                if (cIMInstance == null) throw new CIMException("CIMInstance is null.");
                cIMInstance.setProperty("ComputerSystemCreationClassName", new CIMValue((Object)"IBMHSC_ComputerSystem"));
                cIMInstance.setProperty("ComputerSystemName", new CIMValue((Object)string));
                cIMInstance.setProperty("DataTag", new CIMValue((Object)string2));
                cIMInstance.setProperty("Data", new CIMValue((Object)string3));
                cIMClient.createInstance(cIMObjectPath, cIMInstance);
            }
        }
        if (1 > Trace.LEVEL) return;
        Trace.trace(TRACE_MASKT, "<-set(...)");
    }

    private static void delete(CIMClient cIMClient, String string, String string2) throws CIMException {
        Object var3_3 = null;
        Object var4_4 = null;
        CIMObjectPath cIMObjectPath = null;
        boolean bl = false;
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "->delete(" + cIMClient + ", " + string + ", " + string2 + ")");
        }
        if (string2 != null) {
            cIMObjectPath = new CIMObjectPath("IBMHSC_HscInfo");
            if (cIMObjectPath != null) {
                if (3 <= Trace.LEVEL) {
                    Trace.trace(TRACE_MASKD, "got CIM object path");
                }
                cIMObjectPath.addKey("ComputerSystemCreationClassName", new CIMValue((Object)"IBMHSC_ComputerSystem"));
                cIMObjectPath.addKey("ComputerSystemName", new CIMValue((Object)string));
                cIMObjectPath.addKey("DataTag", new CIMValue((Object)string2));
                cIMClient.deleteInstance(cIMObjectPath);
            } else {
                throw new CIMException("CIMObjectPath is null.");
            }
        }
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<-delete(...)");
        }
    }

    private static String encodeValue(String string, int n) {
        if (string != null && string.length() > n) {
            string = ContactInfo.subString(string, n);
        }
        return ContactInfo.encodeValue(string);
    }

    private static String encodeValue(String string) {
        String string2 = null;
        string2 = string != null ? new String(ContactInfo.encodeValueToByteArray(string)) : "";
        return string2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static byte[] encodeValueToByteArray(String string) {
        CharsetEncoder charsetEncoder = null;
        CoderResult coderResult = null;
        CharBuffer charBuffer = null;
        ByteBuffer byteBuffer = null;
        byte[] byArray = null;
        byte by = 0;
        if (string == null) return new byte[0];
        charsetEncoder = Charset.forName("UTF-8").newEncoder().reset();
        charBuffer = CharBuffer.allocate(string.length());
        charBuffer.put(string).rewind();
        byteBuffer = ByteBuffer.allocate(string.length() * (int)charsetEncoder.maxBytesPerChar());
        coderResult = charsetEncoder.encode(charBuffer, byteBuffer, true);
        if (!coderResult.isUnderflow()) throw new IllegalArgumentException();
        coderResult = charsetEncoder.flush(byteBuffer);
        if (!coderResult.isUnderflow()) throw new IllegalArgumentException();
        byArray = new byte[byteBuffer.position()];
        int n = 0;
        while (n < byArray.length) {
            by = byteBuffer.get(n);
            byArray[n] = by == 59 ? 126 : by;
            ++n;
        }
        return byArray;
    }

    private static String decodeValue(String string) {
        return ContactInfo.decodeValue(string.getBytes());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String decodeValue(byte[] byArray) {
        int n;
        String string = null;
        CharsetDecoder charsetDecoder = null;
        CoderResult coderResult = null;
        ByteBuffer byteBuffer = null;
        CharBuffer charBuffer = null;
        char[] cArray = null;
        if (byArray == null) return "";
        if (byArray.length <= 0) return "";
        charsetDecoder = Charset.forName("UTF-8").newDecoder().reset();
        for (n = 0; n < byArray.length; ++n) {
            if (byArray[n] != 126) continue;
            byArray[n] = 59;
        }
        byteBuffer = ByteBuffer.wrap(byArray);
        coderResult = charsetDecoder.decode(byteBuffer, charBuffer = CharBuffer.allocate(byArray.length), true);
        if (!coderResult.isUnderflow()) throw new IllegalArgumentException();
        coderResult = charsetDecoder.flush(charBuffer);
        if (!coderResult.isUnderflow()) throw new IllegalArgumentException();
        cArray = new char[charBuffer.position()];
        n = 0;
        while (n < cArray.length) {
            cArray[n] = charBuffer.get(n);
            ++n;
        }
        return new String(cArray);
    }

    private static String getValue(String string, String string2) {
        String string3 = null;
        int n = 0;
        int n2 = 0;
        if (string != null) {
            n = string.indexOf(61);
            if (string.startsWith(string2)) {
                n2 = string2.length();
                if (string.length() > n2 + 1 && string.charAt(string2.length()) == '=') {
                    string3 = string.substring(n2 + 1);
                }
            }
        }
        return string3;
    }

    private static void printBytes(byte[] byArray) {
        if (byArray != null && byArray.length > 0) {
            System.out.print("0x");
            for (int i = 0; i < byArray.length; ++i) {
                System.out.print(ContactInfo.toHexString(byArray[i]));
            }
        }
    }

    private static String toHexString(byte by) {
        char[] cArray = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        char[] cArray2 = null;
        cArray2 = new char[]{cArray[by >> 4 & 0xF], cArray[by & 0xF]};
        return new String(cArray2);
    }

    private static String toHexString(String string) {
        byte[] byArray = null;
        StringBuffer stringBuffer = null;
        stringBuffer = new StringBuffer();
        if (string != null && string.length() > 0) {
            try {
                byArray = string.getBytes("UTF-16BE");
                stringBuffer.append(ContactInfo.toHexString(byArray));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new IllegalArgumentException();
            }
        }
        return stringBuffer.toString();
    }

    private static String toHexString(byte[] byArray) {
        StringBuffer stringBuffer = null;
        stringBuffer = new StringBuffer();
        if (byArray != null) {
            for (int i = 0; i < byArray.length; ++i) {
                stringBuffer.append(ContactInfo.toHexString(byArray[i]));
            }
        }
        return stringBuffer.toString();
    }

    private static int calcLength(String string, String string2) {
        int n = 0;
        int n2 = 0;
        if (string2 != null && (n2 = string2.getBytes().length) > 0) {
            n = string.length() + 2 + n2;
        }
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<->calcLength( " + string + ", " + string2 + ") returning " + n);
        }
        return n;
    }

    private static String asMuchAsFits(int n, String string, String string2) {
        int n2 = 0;
        String string3 = null;
        String string4 = null;
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "->asMuchAsFits( " + n + ", " + string + ", " + string2 + ")");
        }
        string4 = "";
        if (string2 != null && (n2 = n + string.length() + 2) <= 701) {
            for (int i = string2.length(); i > 0; --i) {
                if (ContactInfo.isHighSurrogate(string2.charAt(i - 1)) || n2 + (string3 = ContactInfo.encodeValue(string2.substring(0, i))).getBytes().length > 702) continue;
                string4 = string3;
                break;
            }
        }
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<-asMuchAsFits(...) returning " + string4);
        }
        return string4;
    }

    private static String subString(String string, int n) {
        StringBuffer stringBuffer = null;
        int n2 = 0;
        char c = '\u0000';
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "->subString( " + string + ", " + n + ")");
        }
        stringBuffer = new StringBuffer();
        n2 = 0;
        for (int i = 0; n2 < n && i < string.length(); ++i) {
            c = string.charAt(i);
            if (!ContactInfo.isHighSurrogate(c)) {
                stringBuffer.append(c);
                ++n2;
                continue;
            }
            if (i + 1 >= string.length()) continue;
            stringBuffer.append(c);
            stringBuffer.append(string.charAt(i + 1));
            ++i;
            ++n2;
        }
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<-subString(...) returning " + stringBuffer.toString());
        }
        return stringBuffer.toString();
    }

    private static boolean isHighSurrogate(char c) {
        return c >= '\ud800' && c <= '\udbff';
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

